## part of the code is from and modified: https://github.com/artemyk/ibsgd 

import tensorflow as tf
import numpy as np
import os
from tensorflow.keras import backend as K
from. import utils

def generate_data():

    (x_train, y_train), (x_test, y_test) = tf.keras.datasets.mnist.load_data()

    # normalization to 1
    x_train = (x_train / 255.0)
    x_test = (x_test / 255.0)

    x_train = x_train.reshape(x_train.shape[0], -1)
    x_test = x_test.reshape(x_test.shape[0], -1)

    Y_train = tf.keras.utils.to_categorical(y_train, 10)
    Y_test = tf.keras.utils.to_categorical(y_test, 10)


    return x_train,Y_train,x_test,Y_test

class getMIOutput(tf.keras.callbacks.Callback):
    def __init__(self, trn, tst, Z_layer_idx, num_selection, do_save_func=None, *kargs, **kwargs):
        super(getMIOutput, self).__init__(*kargs, **kwargs)
        self.trn = trn
        self.tst = tst
        self.Z_layer_idx = Z_layer_idx
        self.num_selection = num_selection
        self.do_save_func = do_save_func # control the saved epoch
        self.layer_values = []
        self.layerixs = []
        self.layerfuncs = []

    def on_train_begin(self, logs=None):
        for lndx, l in enumerate(self.model.layers):
            self.layerixs.append(lndx)
            self.layer_values.append(lndx)
            self.layerfuncs.append(K.function(self.model.inputs, [l.output,]))

    def on_epoch_end(self, epoch, logs=None):
        if self.do_save_func is not None and not self.do_save_func(epoch):
            return

        data = {
            'activity': []  # Activity in each layer
        }

        for lndx, layerix in enumerate(self.layerixs):
            if lndx == self.Z_layer_idx:
                clayer = self.model.layers[layerix]
                activity_tst = self.layerfuncs[lndx]([self.trn[:self.num_selection],])[0]
                data['activity'].append(activity_tst)

        # Convert the list of numpy arrays to a single numpy array for npy compatibility
        activity_tst_array = np.array(data['activity']).reshape(self.num_selection, -1)
        
        # Save the numpy array to an npy file
        filename = f"MN_epoch_{epoch}_z_{self.Z_layer_idx}.npy"
        filepath = os.path.join('savedata', filename)
        np.save(filepath, activity_tst_array)

        print(f"Saved data for epoch {epoch} to {filename}")
        
        
def do_report_MN(epoch):
    if epoch < 100  :       
        return (epoch % 1 == 0)
    elif epoch < 200  :
        return (epoch % 5 == 0)
    
    

def train_model(config):
    # Get data
    x_1train,Y_1train,x_1test,Y_1test = generate_data()

    # Model training
    tf.keras.backend.clear_session()
    tf.random.set_seed(42)

    input_layer = tf.keras.layers.Input((x_1train.shape[1],))
    x = tf.keras.layers.Dense(1024, activation='relu')(input_layer)
    x = tf.keras.layers.Dense(20, activation='relu')(x)
    x = tf.keras.layers.Dense(20, activation='relu')(x)
    x = tf.keras.layers.Dense(20, activation='relu')(x)
    CE_output = tf.keras.layers.Dense(10, activation='softmax', name='CE')(x)

    model = tf.keras.Model(inputs=input_layer, outputs=[CE_output])

    # Use the optimizer and learning rate from the config
    if config["optimizer"] == "SGD":
        opt = tf.keras.optimizers.SGD(learning_rate=config["lr"])
    elif config["optimizer"] == "Adam":
        opt = tf.keras.optimizers.Adam(learning_rate=config["lr"])
    # Add other optimizers as needed

    model.compile(optimizer=opt,
                  loss={'CE': 'categorical_crossentropy'},
                  metrics={'CE': 'accuracy'})

    reporter = getMIOutput(trn=x_1train,
                           tst=x_1test,
                           Z_layer_idx=config["z_idx"],  # Use z_idx from config
                           num_selection=10000,
                           do_save_func=do_report_MN)

    history = model.fit(x=x_1train, y=Y_1train,
                        batch_size=config["batch_size"],  # Use batch size from config
                        epochs=config["epoch"],  # Use number of epochs from config
                        verbose=0,
                        validation_data=(x_1test, Y_1test),
                        callbacks=[reporter,])

    # Print the final generalization gap (train accuracy - test accuracy / train loss - test loss)
    final_train_acc = history.history['accuracy'][-1]
    final_val_acc = history.history['val_accuracy'][-1]
    final_train_loss = history.history['loss'][-1]
    final_val_loss = history.history['val_loss'][-1]

    generalization_gap_acc = final_train_acc - final_val_acc
    generalization_gap_loss = final_train_loss - final_val_loss

    print(f"Final Generalization Gap (Accuracy): {generalization_gap_acc}")
    print(f"Final Generalization Gap (Loss): {generalization_gap_loss}")
    print(f"Final Train Accuracy: {final_train_acc}")
    print(f"Final Val Accuracy: {final_val_acc}")


